VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Externally clocked, Buffered CT"
   ClientHeight    =   7125
   ClientLeft      =   1995
   ClientTop       =   1620
   ClientWidth     =   5280
   LinkTopic       =   "Form1"
   ScaleHeight     =   7125
   ScaleWidth      =   5280
   Begin VB.ListBox List2 
      Height          =   2985
      Left            =   2160
      TabIndex        =   10
      Top             =   3120
      Width           =   975
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   495
      Left            =   4080
      TabIndex        =   8
      Top             =   6360
      Width           =   735
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   495
      Left            =   2520
      TabIndex        =   5
      Top             =   1560
      Width           =   1335
   End
   Begin VB.ListBox List1 
      Height          =   2985
      Left            =   720
      TabIndex        =   4
      Top             =   3120
      Width           =   975
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   4320
      Top             =   1200
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   3
      Text            =   "Text1"
      Top             =   2280
      Width           =   3375
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   2
      Text            =   "0"
      Top             =   960
      Width           =   615
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Enabled         =   0   'False
      Height          =   495
      Left            =   600
      TabIndex        =   1
      Top             =   1560
      Width           =   1575
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open and Init"
      Height          =   495
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1575
   End
   Begin VB.Label Label4 
      Caption         =   "Counter 1 Data"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2160
      TabIndex        =   11
      Top             =   2880
      Width           =   1335
   End
   Begin VB.Label Label3 
      Caption         =   "Counter 0 Data"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   720
      TabIndex        =   9
      Top             =   2880
      Width           =   1335
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2520
      TabIndex        =   7
      Top             =   720
      Width           =   2175
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   6
      Top             =   240
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim bufSize As Integer
Dim CTBuffer() As Integer
Dim CorrectedCTBuffer() As Long
' this program was tested in Win2K SP4 with a CTM-05/A board
' using CTM-850A01.0.0.2 version of DriverLINX and VB6 Pro
'
' this example configures counter channels 0 and 1 for AM9513 Mode D
' of operation which basically allows the counters to count.  Apply
' a TTL signal at the inputs of each of these counters.
'
' Each of the counter values will be read one time in response
' to a rising edge at the external IRQ pin of the CTM board.
' When 50 rising edges have occured, a 100 sample buffer will be
' full and a buffer filled mesage will be sent.
'
' to use the external IRQ, pull the AENB line to GND and
' apply rising edges at the AINT.
'
' Modify for edge triggered counting to perform time interval
' measurements for a start/stop pulse (the pulses are the edge
' triggers at the gates of the two counters).  Once both counters
' have started, but not rolled over, the difference in their count value
' represents the time elapsed between the two pulses.


Private Sub cmdExit_Click()
' stop any active task
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
' unload driver
DriverLINXSR1.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
With DriverLINXSR1
.Req_DLL_name = "kmbctm"
.Req_device = devNum.ListIndex
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStart.Enabled = True
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If
' configure two channels of the CTM board for Mode D of the AM9513 chip.
' Mode D = repetitive counting with no hardware gating
' see Hardware Reference section of ctmguide.pdf in \drvlinx4\docs\
'
' this is a group mode operation.....
Dim chan As Integer
For chan = 0 To 1
With DriverLINXSR1
.Req_op = DL_CONFIGURE 'configure operation for group operation
.Req_mode = DL_OTHER
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = chan  ' config each channel
.Evt_Tim_rateClock = DL_EXTERNAL   ' apply TTL signal to input of each counter
.Evt_Tim_rateGate = DL_NOCONNECT
.Evt_Tim_rateMode = DL_RATEGEN   ' mode D
.Evt_Tim_rateOnCount = 0
.Evt_Tim_rateOutput = CT_Output_Default
.Evt_Tim_ratePeriod = 65535 'number of tics between TC
.Evt_Tim_ratePulses = 0
.Refresh
End With
Next chan
txtStatus.Text = DriverLINXSR1.Message
' set focus back to our form
Form1.SetFocus
End Sub

Private Sub cmdStart_Click()
List1.Clear
bufSize = 100  ' how many CT samples per buffer
With DriverLINXSR1
.Req_op = DL_START
.Req_mode = DL_INTERRUPT   'this will be an interrupt-driven application
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND


' program the rate at which the counters will elapse......
' externally clocked
.Evt_Tim_type = DL_DIEVENT            ' use AINT as timing source
.Evt_Tim_diChannel = DL_DI_EXTCLK
.Evt_Tim_diMask = 1
.Evt_Tim_diMatch = DL_NotEquals
.Evt_Tim_diPattern = 0                ' 0 for rising edge

.Evt_Tim_ratePulses = 0
.Evt_Tim_rateOnCount = 0
.Sel_chan_N = 2  ' 2 = start channel and stop channel
.Sel_chan_start = 0  ' start on CT0
.Sel_chan_stop = 1   ' stop on CT1...could be higher number CT if interested
' in more CT channels...but configure them too for counting and make
' sure the buf_samples is multiple of how many channels
.Sel_chan_simultaneousScan = True  ' read all CT channels for each clock pulse
.Sel_buf_N = 10  ' how many buffers
.Sel_buf_samples = bufSize  ' how many samples in each buffer
' buffer size and the clock rate dictate how fast buffers fill and how often
' buffer filled messages are sent.  Not practical to send messages at rate
' faster than about 10 to 50 msec (machine and OS dependent).
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages when bufSize samples are available
.Sel_chan_format = DL_tNATIVE
.Refresh
End With

If DriverLINXSR1.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdStart.Enabled = False
txtStatus.Text = DriverLINXSR1.Message
Else
txtStatus.Text = DriverLINXSR1.Message
End If



End Sub

Private Sub cmdStop_Click()
With DriverLINXSR1
.Req_op = DL_STOP
.Refresh
End With
cmdStop.Enabled = False
cmdStart.Enabled = True
End Sub

Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
List1.Clear
List2.Clear
'Beep
txtStatus.Text = "the data are here....."
ReDim CTBuffer(bufSize) As Integer   ' size this dynamically !!!
ReDim CorrectedCTBuffer(bufSize) As Long
Dim dummy As Long
Dim i As Integer
dummy = DriverLINXSR1.VBArrayBufferXfer(bufIndex, CTBuffer, DL_BufferToVBArray)

' in VB, integer is signed, so ranges from -32768 to +32767
'  32767 + 1 = negative number in VB Integer land
'
' but CT value is unsigned: 0 to 65535
' test for negative and if so, cast as a long
'
For i = 0 To DriverLINXSR1.Sel_buf_samples - 1
    If CTBuffer(i) < 0 Then
        CorrectedCTBuffer(i) = CTBuffer(i) + 65536  ' cast as long
    Else
        CorrectedCTBuffer(i) = CTBuffer(i)  ' it was in range of 0 to +32767
    End If
Next i

For i = 0 To 20 Step 2  ' resize as function of bufSize
List1.AddItem CorrectedCTBuffer(i)  ' even number are from first counter
Next i

For i = 1 To 21 Step 2
List2.AddItem CorrectedCTBuffer(i)  ' odd number are from second counter
Next i
End Sub

Private Sub Form_Load()
' populate the drop down with legal device numbers
devNum.AddItem "0", 0
devNum.AddItem "1", 1
devNum.AddItem "2", 2
devNum.AddItem "3", 3
devNum.AddItem "4", 4
devNum.AddItem "5", 5
' set it to select device 0 by default
devNum.ListIndex = 0
End Sub
